/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class FileStream
implements PhysicalOggStream {
    private boolean closed = false;
    private final RandomAccessFile source;
    private final long[] pageOffsets;
    private final HashMap logicalStreams = new HashMap();

    public FileStream(RandomAccessFile source) throws OggFormatException, IOException {
        this.source = source;
        ArrayList<Long> po = new ArrayList<Long>();
        int pageNumber = 0;
        try {
            while (true) {
                po.add(this.source.getFilePointer());
                OggPage op = this.getNextPage(pageNumber > 0);
                if (op != null) {
                    LogicalOggStreamImpl los = (LogicalOggStreamImpl)this.getLogicalStream(op.getStreamSerialNumber());
                    if (los == null) {
                        los = new LogicalOggStreamImpl(this, op.getStreamSerialNumber());
                        this.logicalStreams.put(op.getStreamSerialNumber(), los);
                    }
                    if (pageNumber == 0) {
                        los.checkFormat(op);
                    }
                    los.addPageNumberMapping(pageNumber);
                    los.addGranulePosition(op.getAbsoluteGranulePosition());
                    if (pageNumber > 0) {
                        this.source.seek(this.source.getFilePointer() + (long)op.getTotalLength());
                    }
                    ++pageNumber;
                    continue;
                }
                break;
            }
        }
        catch (EndOfOggStreamException op) {
        }
        catch (IOException e) {
            throw e;
        }
        this.source.seek(0L);
        this.pageOffsets = new long[po.size()];
        int i = 0;
        for (Object e : po) {
            this.pageOffsets[i++] = (Long)e;
        }
    }

    @Override
    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.source.close();
    }

    private OggPage getNextPage(boolean skipData) throws IOException {
        return OggPage.create(this.source, skipData);
    }

    @Override
    public OggPage getOggPage(int index) throws IOException {
        this.source.seek(this.pageOffsets[index]);
        return OggPage.create(this.source);
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return (LogicalOggStream)this.logicalStreams.get(serialNumber);
    }

    @Override
    public void setTime(long granulePosition) throws IOException {
        for (Object o : this.logicalStreams.values()) {
            LogicalOggStream los = (LogicalOggStream)o;
            los.setTime(granulePosition);
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }
}

