/*
 * Decompiled with CFR 0.152.
 */
package jme3test.helloworld;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;

public class HelloPhysics
extends SimpleApplication {
    private BulletAppState bulletAppState;
    private Material wall_mat;
    private Material stone_mat;
    private Material floor_mat;
    private static final Box box;
    private static final Sphere sphere;
    private static final Box floor;
    private static final float brickLength = 0.48f;
    private static final float brickWidth = 0.24f;
    private static final float brickHeight = 0.12f;
    private final ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("shoot") && !keyPressed) {
                HelloPhysics.this.makeCannonBall();
            }
        }
    };

    public static void main(String[] args) {
        HelloPhysics app = new HelloPhysics();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.cam.setLocation(new Vector3f(0.0f, 4.0f, 6.0f));
        this.cam.lookAt(new Vector3f(2.0f, 2.0f, 0.0f), Vector3f.UNIT_Y);
        this.initInputs();
        this.initMaterials();
        this.initWall();
        this.initFloor();
        this.initCrossHairs();
    }

    private void initInputs() {
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
    }

    public void initMaterials() {
        this.wall_mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key = new TextureKey("Textures/Terrain/BrickWall/BrickWall.jpg");
        key.setGenerateMips(true);
        Texture tex = this.assetManager.loadTexture(key);
        this.wall_mat.setTexture("ColorMap", tex);
        this.stone_mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key2 = new TextureKey("Textures/Terrain/Rock/Rock.PNG");
        key2.setGenerateMips(true);
        Texture tex2 = this.assetManager.loadTexture(key2);
        this.stone_mat.setTexture("ColorMap", tex2);
        this.floor_mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key3 = new TextureKey("Textures/Terrain/Pond/Pond.jpg");
        key3.setGenerateMips(true);
        Texture tex3 = this.assetManager.loadTexture(key3);
        tex3.setWrap(Texture.WrapMode.Repeat);
        this.floor_mat.setTexture("ColorMap", tex3);
    }

    public void initFloor() {
        Geometry floor_geo = new Geometry("Floor", (Mesh)floor);
        floor_geo.setMaterial(this.floor_mat);
        floor_geo.setLocalTranslation(0.0f, -0.1f, 0.0f);
        this.rootNode.attachChild((Spatial)floor_geo);
        RigidBodyControl floor_phy = new RigidBodyControl(0.0f);
        floor_geo.addControl((Control)floor_phy);
        this.bulletAppState.getPhysicsSpace().add((Object)floor_geo);
    }

    public void initWall() {
        float startX = 0.12f;
        float height = 0.0f;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 6; ++i) {
                Vector3f vt = new Vector3f((float)i * 0.48f * 2.0f + startX, 0.12f + height, 0.0f);
                this.makeBrick(vt);
            }
            startX = -startX;
            height += 0.24f;
        }
    }

    private void makeBrick(Vector3f loc) {
        Geometry brick_geo = new Geometry("brick", (Mesh)box);
        brick_geo.setMaterial(this.wall_mat);
        this.rootNode.attachChild((Spatial)brick_geo);
        brick_geo.setLocalTranslation(loc);
        RigidBodyControl brick_phy = new RigidBodyControl(2.0f);
        brick_geo.addControl((Control)brick_phy);
        this.bulletAppState.getPhysicsSpace().add((Object)brick_phy);
    }

    public void makeCannonBall() {
        Geometry ball_geo = new Geometry("cannon ball", (Mesh)sphere);
        ball_geo.setMaterial(this.stone_mat);
        this.rootNode.attachChild((Spatial)ball_geo);
        ball_geo.setLocalTranslation(this.cam.getLocation());
        RigidBodyControl ball_phy = new RigidBodyControl(1.0f);
        ball_geo.addControl((Control)ball_phy);
        this.bulletAppState.getPhysicsSpace().add((Object)ball_phy);
        ball_phy.setLinearVelocity(this.cam.getDirection().mult(25.0f));
    }

    protected void initCrossHairs() {
        this.setDisplayStatView(false);
        BitmapText ch = new BitmapText(this.guiFont);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2), (float)(this.settings.getHeight() / 2), 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager rm) {
    }

    static {
        sphere = new Sphere(32, 32, 0.4f, true, false);
        sphere.setTextureMode(Sphere.TextureMode.Projected);
        box = new Box(0.48f, 0.12f, 0.24f);
        box.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        floor = new Box(10.0f, 0.1f, 5.0f);
        floor.scaleTextureCoordinates(new Vector2f(3.0f, 6.0f));
    }
}

