/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.savegame;

import com.jme3.asset.AssetManager;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.system.JmeSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SaveGame {
    private SaveGame() {
    }

    public static void saveGame(String gamePath, String dataName, Savable data) {
        SaveGame.saveGame(gamePath, dataName, data, JmeSystem.StorageFolderType.External);
    }

    public static void saveGame(String gamePath, String dataName, Savable data, JmeSystem.StorageFolderType storageType) {
        if (storageType == null) {
            Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Base Storage Folder Type is null, using External!");
            storageType = JmeSystem.StorageFolderType.External;
        }
        BinaryExporter ex = BinaryExporter.getInstance();
        OutputStream os = null;
        try {
            File baseFolder = JmeSystem.getStorageFolder(storageType);
            if (baseFolder == null) {
                Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error creating save file!");
                throw new IllegalStateException("SaveGame dataset cannot be created");
            }
            File daveFolder = new File(baseFolder.getAbsolutePath() + File.separator + gamePath.replace('/', File.separatorChar));
            if (!daveFolder.exists() && !daveFolder.mkdirs()) {
                Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error creating save file!");
                throw new IllegalStateException("SaveGame dataset cannot be created");
            }
            File saveFile = new File(daveFolder.getAbsolutePath() + File.separator + dataName);
            if (!saveFile.exists() && !saveFile.createNewFile()) {
                Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error creating save file!");
                throw new IllegalStateException("SaveGame dataset cannot be created");
            }
            os = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(saveFile)));
            ex.save(data, os);
            Logger.getLogger(SaveGame.class.getName()).log(Level.FINE, "Saving data to: {0}", saveFile.getAbsolutePath());
        }
        catch (IOException ex1) {
            Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error saving data: {0}", ex1);
            ex1.printStackTrace();
            throw new IllegalStateException("SaveGame dataset cannot be saved");
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex1) {
                Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error saving data: {0}", ex1);
                ex1.printStackTrace();
                throw new IllegalStateException("SaveGame dataset cannot be saved");
            }
        }
    }

    public static Savable loadGame(String gamePath, String dataName) {
        return SaveGame.loadGame(gamePath, dataName, null, JmeSystem.StorageFolderType.External);
    }

    public static Savable loadGame(String gamePath, String dataName, JmeSystem.StorageFolderType storageType) {
        return SaveGame.loadGame(gamePath, dataName, null, storageType);
    }

    public static Savable loadGame(String gamePath, String dataName, AssetManager manager) {
        return SaveGame.loadGame(gamePath, dataName, manager, JmeSystem.StorageFolderType.External);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Savable loadGame(String gamePath, String dataName, AssetManager manager, JmeSystem.StorageFolderType storageType) {
        if (storageType == null) {
            Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Base Storage Folder Type is null, using External!");
            storageType = JmeSystem.StorageFolderType.External;
        }
        InputStream is = null;
        Savable sav = null;
        try {
            File baseFolder = JmeSystem.getStorageFolder(storageType);
            if (baseFolder == null) {
                Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error reading base storage folder!");
                Savable savable = null;
                return savable;
            }
            File file = new File(baseFolder.getAbsolutePath() + File.separator + gamePath.replace('/', File.separatorChar) + File.separator + dataName);
            if (!file.exists()) {
                Savable ex = null;
                return ex;
            }
            is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
            BinaryImporter imp = BinaryImporter.getInstance();
            if (manager != null) {
                imp.setAssetManager(manager);
            }
            sav = imp.load(is);
            Logger.getLogger(SaveGame.class.getName()).log(Level.FINE, "Loading data from: {0}", file.getAbsolutePath());
        }
        catch (IOException ex) {
            Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error loading data: {0}", ex);
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SaveGame.class.getName()).log(Level.SEVERE, "Error loading data: {0}", ex);
                    ex.printStackTrace();
                }
            }
        }
        return sav;
    }
}

