/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.util.NativeObject;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeObjectManager {
    private static final Logger logger = Logger.getLogger(NativeObjectManager.class.getName());
    public static boolean UNSAFE = false;
    private static final int MAX_REMOVES_PER_FRAME = 100;
    private ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final HashMap<Long, NativeObjectRef> refMap = new HashMap();
    private final ArrayDeque<NativeObject> userDeletionQueue = new ArrayDeque();

    public void registerObject(NativeObject obj) {
        if (obj.getId() <= 0) {
            throw new IllegalArgumentException("object id must be greater than zero");
        }
        NativeObjectRef ref = new NativeObjectRef(this.refQueue, obj);
        this.refMap.put(obj.getUniqueId(), ref);
        obj.setNativeObjectManager(this);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Registered: {0}", new String[]{obj.toString()});
        }
    }

    private void deleteNativeObject(Object rendererObject, NativeObject obj, NativeObjectRef ref, boolean deleteGL, boolean deleteBufs) {
        NativeObject realObj;
        assert (rendererObject != null);
        NativeObject nativeObject = realObj = ref != null ? (NativeObject)ref.realObj.get() : obj;
        assert (realObj == null || obj.getId() == realObj.getId());
        if (deleteGL) {
            if (obj.getId() <= 0) {
                logger.log(Level.WARNING, "Object already deleted: {0}", obj.getClass().getSimpleName() + "/" + obj.getId());
            } else {
                NativeObjectRef ref2 = this.refMap.remove(obj.getUniqueId());
                if (ref2 == null) {
                    throw new IllegalArgumentException("The " + obj + " NativeObject is not registered in this NativeObjectManager");
                }
                assert (ref == null || ref == ref2);
                ref2.clear();
                int id = obj.getId();
                obj.deleteObject(rendererObject);
                assert (obj.getId() == -1);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Deleted: {0}", obj.getClass().getSimpleName() + "/" + id);
                }
                if (realObj != null) {
                    realObj.resetObject();
                }
            }
        }
        if (deleteBufs && UNSAFE && realObj != null) {
            realObj.deleteNativeBuffersInternal();
        }
    }

    public void deleteUnused(Object rendererObject) {
        NativeObjectRef ref;
        int removed;
        for (removed = 0; removed < 100 && !this.userDeletionQueue.isEmpty(); ++removed) {
            NativeObject obj = this.userDeletionQueue.pop();
            this.deleteNativeObject(rendererObject, obj, null, true, true);
        }
        while (removed < 100 && (ref = (NativeObjectRef)this.refQueue.poll()) != null) {
            this.deleteNativeObject(rendererObject, ref.objClone, ref, true, false);
            ++removed;
        }
        if (removed >= 1) {
            logger.log(Level.FINE, "NativeObjectManager: {0} native objects were removed from native", removed);
        }
    }

    public void deleteAllObjects(Object rendererObject) {
        this.deleteUnused(rendererObject);
        ArrayList<NativeObjectRef> refMapCopy = new ArrayList<NativeObjectRef>(this.refMap.values());
        for (NativeObjectRef ref : refMapCopy) {
            this.deleteNativeObject(rendererObject, ref.objClone, ref, true, false);
        }
        assert (this.refMap.size() == 0);
    }

    void enqueueUnusedObject(NativeObject obj) {
        this.userDeletionQueue.push(obj);
    }

    public void resetObjects() {
        for (NativeObjectRef ref : this.refMap.values()) {
            NativeObject realObj = (NativeObject)ref.realObj.get();
            if (realObj == null) continue;
            realObj.resetObject();
            logger.log(Level.FINEST, "Reset: {0}", realObj);
        }
        this.refMap.clear();
        this.refQueue = new ReferenceQueue();
    }

    private static class NativeObjectRef
    extends PhantomReference<Object> {
        private final NativeObject objClone;
        private final WeakReference<NativeObject> realObj;

        public NativeObjectRef(ReferenceQueue<Object> refQueue, NativeObject obj) {
            super(obj.handleRef, refQueue);
            assert (obj.handleRef != null);
            this.realObj = new WeakReference<NativeObject>(obj);
            this.objClone = obj.createDestructableClone();
            assert (this.objClone.getId() == obj.getId());
        }
    }
}

