/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.ShaderNodeVariable;
import java.io.IOException;
import java.util.Objects;

public class VariableMapping
implements Savable,
Cloneable {
    private ShaderNodeVariable leftVariable;
    private ShaderNodeVariable rightVariable;
    private String rightExpression;
    private String condition;
    private String leftSwizzling = "";
    private String rightSwizzling = "";

    public VariableMapping() {
    }

    public VariableMapping(ShaderNodeVariable leftVariable, String leftSwizzling, ShaderNodeVariable rightVariable, String rightSwizzling, String condition) {
        this.leftVariable = leftVariable;
        this.rightVariable = rightVariable;
        this.condition = condition;
        this.leftSwizzling = Objects.requireNonNull(leftSwizzling);
        this.rightSwizzling = Objects.requireNonNull(rightSwizzling);
    }

    public ShaderNodeVariable getLeftVariable() {
        return this.leftVariable;
    }

    public void setLeftVariable(ShaderNodeVariable leftVariable) {
        this.leftVariable = leftVariable;
    }

    public ShaderNodeVariable getRightVariable() {
        return this.rightVariable;
    }

    public void setRightVariable(ShaderNodeVariable rightVariable) {
        this.rightVariable = rightVariable;
    }

    public String getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(String rightExpression) {
        this.rightExpression = rightExpression;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getLeftSwizzling() {
        return this.leftSwizzling;
    }

    public void setLeftSwizzling(String leftSwizzling) {
        this.leftSwizzling = Objects.requireNonNull(leftSwizzling);
    }

    public String getRightSwizzling() {
        return this.rightSwizzling;
    }

    public void setRightSwizzling(String rightSwizzling) {
        this.rightSwizzling = Objects.requireNonNull(rightSwizzling);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.leftVariable, "leftVariable", null);
        oc.write(this.rightVariable, "rightVariable", null);
        oc.write(this.rightExpression, "rightExpression", null);
        oc.write(this.condition, "condition", "");
        oc.write(this.leftSwizzling, "leftSwizzling", "");
        oc.write(this.rightSwizzling, "rightSwizzling", "");
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.leftVariable = (ShaderNodeVariable)ic.readSavable("leftVariable", null);
        this.rightVariable = (ShaderNodeVariable)ic.readSavable("rightVariable", null);
        this.rightExpression = ic.readString("rightExpression", null);
        this.condition = ic.readString("condition", "");
        this.leftSwizzling = ic.readString("leftSwizzling", "");
        this.rightSwizzling = ic.readString("rightSwizzling", "");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.leftVariable.toString());
        if (!this.leftSwizzling.isEmpty()) {
            builder.append('.').append(this.leftSwizzling);
        }
        builder.append(" = ");
        if (this.rightVariable != null) {
            builder.append(this.rightVariable.getType()).append(' ').append(this.rightVariable.getNameSpace()).append('.').append(this.rightVariable.getName());
            if (!this.rightSwizzling.isEmpty()) {
                builder.append('.').append(this.rightSwizzling);
            }
        } else if (this.rightExpression != null) {
            builder.append(this.rightExpression);
        }
        if (this.condition != null && !this.condition.isEmpty()) {
            builder.append(" : ").append(this.condition);
        }
        return builder.toString();
    }

    protected VariableMapping clone() throws CloneNotSupportedException {
        VariableMapping clone = (VariableMapping)super.clone();
        clone.leftVariable = this.leftVariable.clone();
        if (this.rightVariable != null) {
            clone.rightVariable = this.rightVariable.clone();
        }
        return clone;
    }
}

