/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.shader.ShaderVariable;
import com.jme3.shader.bufferobject.BufferObject;
import java.lang.ref.WeakReference;

public class ShaderBufferBlock
extends ShaderVariable {
    protected BufferObject bufferObject;
    protected WeakReference<BufferObject> bufferObjectRef;
    protected BufferType type;

    public void setBufferObject(BufferType type, BufferObject bufferObject) {
        if (bufferObject == null) {
            throw new IllegalArgumentException("for storage block " + this.name + ": storageData cannot be null");
        }
        if (bufferObject == this.bufferObject && type == this.type) {
            return;
        }
        this.bufferObject = bufferObject;
        this.bufferObjectRef = new WeakReference<BufferObject>(bufferObject);
        this.type = type;
        this.updateNeeded = true;
    }

    public BufferType getType() {
        return this.type;
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public void clearUpdateNeeded() {
        this.updateNeeded = false;
    }

    public void reset() {
        this.location = -1;
        this.updateNeeded = true;
    }

    public BufferObject getBufferObject() {
        return this.bufferObject;
    }

    public WeakReference<BufferObject> getBufferObjectRef() {
        return this.bufferObjectRef;
    }

    public void setBufferObjectRef(WeakReference<BufferObject> bufferObjectRef) {
        this.bufferObjectRef = bufferObjectRef;
    }

    public static enum BufferType {
        UniformBufferObject,
        ShaderStorageBufferObject;

    }
}

