/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.shader.VarType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public final class DefineList {
    private final BitSet isSet;
    private final int[] values;

    public DefineList(int numValues) {
        if (numValues < 0) {
            throw new IllegalArgumentException("numValues must be >= 0");
        }
        this.values = new int[numValues];
        this.isSet = new BitSet(numValues);
    }

    private DefineList(DefineList original) {
        this.isSet = (BitSet)original.isSet.clone();
        this.values = new int[original.values.length];
        System.arraycopy(original.values, 0, this.values, 0, this.values.length);
    }

    private void rangeCheck(int id) {
        assert (0 <= id && id < this.values.length);
    }

    public boolean isSet(int id) {
        this.rangeCheck(id);
        return this.isSet.get(id);
    }

    public void unset(int id) {
        this.rangeCheck(id);
        this.isSet.clear(id);
        this.values[id] = 0;
    }

    public void set(int id, int val) {
        this.rangeCheck(id);
        this.isSet.set(id, true);
        this.values[id] = val;
    }

    public void set(int id, float val) {
        this.set(id, Float.floatToIntBits(val));
    }

    public void set(int id, boolean val) {
        if (val) {
            this.set(id, 1);
        } else {
            this.unset(id);
        }
    }

    public void set(int id, VarType type, Object value) {
        if (value != null) {
            switch (type) {
                case Int: {
                    this.set(id, (Integer)value);
                    break;
                }
                case Float: {
                    this.set(id, ((Float)value).floatValue());
                    break;
                }
                case Boolean: {
                    this.set(id, (Boolean)value);
                    break;
                }
                default: {
                    this.set(id, 1);
                    break;
                }
            }
        } else {
            this.unset(id);
        }
    }

    public void setAll(DefineList other) {
        for (int i = 0; i < other.values.length; ++i) {
            if (!other.isSet(i)) continue;
            this.set(i, other.getInt(i));
        }
    }

    public void clear() {
        this.isSet.clear();
        Arrays.fill(this.values, 0);
    }

    public boolean getBoolean(int id) {
        return this.values[id] != 0;
    }

    public float getFloat(int id) {
        return Float.intBitsToFloat(this.values[id]);
    }

    public int getInt(int id) {
        return this.values[id];
    }

    public int hashCode() {
        return this.isSet.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DefineList otherDefineList = (DefineList)object;
        if (this.values.length != otherDefineList.values.length) {
            return false;
        }
        if (!this.isSet.equals(otherDefineList.isSet)) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == otherDefineList.values[i]) continue;
            return false;
        }
        return true;
    }

    public DefineList deepClone() {
        return new DefineList(this);
    }

    public void generateSource(StringBuilder sb, List<String> defineNames, List<VarType> defineTypes) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.isSet(i)) continue;
            sb.append("#define ").append(defineNames.get(i)).append(' ');
            if (defineTypes != null && defineTypes.get(i) == VarType.Float) {
                float val = Float.intBitsToFloat(this.values[i]);
                if (Float.isInfinite(val) || Float.isNaN(val)) {
                    throw new IllegalArgumentException("GLSL does not support NaN or Infinite float literals");
                }
                sb.append(val);
            } else {
                sb.append(this.values[i]);
            }
            sb.append('\n');
        }
    }

    public String generateSource(List<String> defineNames, List<VarType> defineTypes) {
        StringBuilder sb = new StringBuilder();
        this.generateSource(sb, defineNames, defineTypes);
        return sb.toString();
    }
}

