/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug;

import com.jme3.animation.Skeleton;
import com.jme3.export.JmeImporter;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.debug.SkeletonInterBoneWire;
import com.jme3.scene.debug.SkeletonPoints;
import com.jme3.scene.debug.SkeletonWire;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Map;

public class SkeletonDebugger
extends Node {
    private SkeletonWire wires;
    private SkeletonPoints points;
    private SkeletonInterBoneWire interBoneWires;

    public SkeletonDebugger() {
    }

    public SkeletonDebugger(String name, Skeleton skeleton) {
        this(name, skeleton, null);
    }

    public SkeletonDebugger(String name, Skeleton skeleton, Map<Integer, Float> boneLengths) {
        super(name);
        this.wires = new SkeletonWire(skeleton, boneLengths);
        this.points = new SkeletonPoints(skeleton, boneLengths);
        this.attachChild(new Geometry(this.getGeometryName("_wires"), this.wires));
        this.attachChild(new Geometry(this.getGeometryName("_points"), this.points));
        if (boneLengths != null) {
            this.interBoneWires = new SkeletonInterBoneWire(skeleton, boneLengths);
            this.attachChild(new Geometry(this.getGeometryName("_interwires"), this.interBoneWires));
        }
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
    }

    private String getGeometryName(String suffix) {
        return this.name + suffix;
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.wires.updateGeometry();
        this.points.updateGeometry();
        if (this.interBoneWires != null) {
            this.interBoneWires.updateGeometry();
        }
    }

    public SkeletonPoints getPoints() {
        return this.points;
    }

    public SkeletonWire getWires() {
        return this.wires;
    }

    public SkeletonInterBoneWire getInterBoneWires() {
        return this.interBoneWires;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.wires = cloner.clone(this.wires);
        this.points = cloner.clone(this.points);
        this.interBoneWires = cloner.clone(this.interBoneWires);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        this.wires = (SkeletonWire)this.getMesh("_wires");
        this.points = (SkeletonPoints)this.getMesh("_points");
        this.interBoneWires = (SkeletonInterBoneWire)this.getMesh("_interwires");
    }

    private <T extends Mesh> T getMesh(String suffix) {
        Geometry child = (Geometry)this.getChild(this.getGeometryName(suffix));
        if (child != null) {
            return (T)child.getMesh();
        }
        return null;
    }
}

