/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.IDList;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Shader;
import com.jme3.shader.bufferobject.BufferObject;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import java.lang.ref.WeakReference;

public class RenderContext {
    public static final int maxTextureUnits = 16;
    public static final int maxBufferObjectUnits = 8;
    public RenderState.FaceCullMode cullMode;
    public boolean depthTestEnabled;
    public boolean depthWriteEnabled;
    public boolean colorWriteEnabled;
    public boolean clipRectEnabled;
    public boolean polyOffsetEnabled;
    public float polyOffsetFactor;
    public float polyOffsetUnits;
    public float pointSize;
    public float lineWidth;
    public RenderState.BlendMode blendMode;
    public RenderState.BlendEquation blendEquation;
    public RenderState.BlendEquationAlpha blendEquationAlpha;
    public RenderState.BlendFunc sfactorRGB;
    public RenderState.BlendFunc dfactorRGB;
    public RenderState.BlendFunc sfactorAlpha;
    public RenderState.BlendFunc dfactorAlpha;
    public boolean wireframe;
    public int boundShaderProgram;
    public Shader boundShader;
    public int boundFBO;
    public FrameBuffer boundFB;
    public int boundRB;
    public int boundElementArrayVBO;
    public int boundVertexArray;
    public int boundArrayVBO;
    public int boundPixelPackPBO;
    public int numTexturesSet;
    public final WeakReference<Image>[] boundTextures = new WeakReference[16];
    public final WeakReference<BufferObject>[] boundBO = new WeakReference[8];
    public final IDList textureIndexList = new IDList();
    public int boundTextureUnit;
    public boolean stencilTest;
    public RenderState.StencilOperation frontStencilStencilFailOperation;
    public RenderState.StencilOperation frontStencilDepthFailOperation;
    public RenderState.StencilOperation frontStencilDepthPassOperation;
    public RenderState.StencilOperation backStencilStencilFailOperation;
    public RenderState.StencilOperation backStencilDepthFailOperation;
    public RenderState.StencilOperation backStencilDepthPassOperation;
    public RenderState.TestFunction frontStencilFunction;
    public RenderState.TestFunction backStencilFunction;
    public final WeakReference<VertexBuffer>[] boundAttribs = new WeakReference[16];
    public final IDList attribIndexList = new IDList();
    public RenderState.TestFunction depthFunc;
    public RenderState.TestFunction alphaFunc;
    public int initialDrawBuf;
    public int initialReadBuf;
    public ColorRGBA clearColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);

    public RenderContext() {
        this.init();
    }

    private void init() {
        this.cullMode = RenderState.FaceCullMode.Off;
        this.depthTestEnabled = false;
        this.depthWriteEnabled = true;
        this.colorWriteEnabled = true;
        this.clipRectEnabled = false;
        this.polyOffsetEnabled = false;
        this.polyOffsetFactor = 0.0f;
        this.polyOffsetUnits = 0.0f;
        this.pointSize = 1.0f;
        this.lineWidth = 1.0f;
        this.blendMode = RenderState.BlendMode.Off;
        this.blendEquation = RenderState.BlendEquation.Add;
        this.blendEquationAlpha = RenderState.BlendEquationAlpha.InheritColor;
        this.sfactorRGB = RenderState.BlendFunc.One;
        this.dfactorRGB = RenderState.BlendFunc.One;
        this.sfactorAlpha = RenderState.BlendFunc.One;
        this.dfactorAlpha = RenderState.BlendFunc.One;
        this.wireframe = false;
        this.boundShaderProgram = 0;
        this.boundShader = null;
        this.boundFBO = 0;
        this.boundFB = null;
        this.boundRB = 0;
        this.boundElementArrayVBO = 0;
        this.boundVertexArray = 0;
        this.boundArrayVBO = 0;
        this.boundPixelPackPBO = 0;
        this.numTexturesSet = 0;
        this.boundTextureUnit = 0;
        this.stencilTest = false;
        this.frontStencilStencilFailOperation = RenderState.StencilOperation.Keep;
        this.frontStencilDepthFailOperation = RenderState.StencilOperation.Keep;
        this.frontStencilDepthPassOperation = RenderState.StencilOperation.Keep;
        this.backStencilStencilFailOperation = RenderState.StencilOperation.Keep;
        this.backStencilDepthFailOperation = RenderState.StencilOperation.Keep;
        this.backStencilDepthPassOperation = RenderState.StencilOperation.Keep;
        this.frontStencilFunction = RenderState.TestFunction.Always;
        this.backStencilFunction = RenderState.TestFunction.Always;
        this.depthFunc = RenderState.TestFunction.Less;
        this.alphaFunc = RenderState.TestFunction.Greater;
        this.cullMode = RenderState.FaceCullMode.Off;
        this.clearColor.set(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void reset() {
        int i;
        this.init();
        for (i = 0; i < this.boundTextures.length; ++i) {
            this.boundTextures[i] = null;
        }
        this.textureIndexList.reset();
        for (i = 0; i < this.boundAttribs.length; ++i) {
            this.boundAttribs[i] = null;
        }
        this.attribIndexList.reset();
    }
}

