/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.Savable;
import com.jme3.math.AbstractTriangle;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.io.Serializable;

public class Triangle
extends AbstractTriangle
implements Savable,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private Vector3f pointA = new Vector3f();
    private Vector3f pointB = new Vector3f();
    private Vector3f pointC = new Vector3f();
    private transient Vector3f center;
    private transient Vector3f normal;
    private float projection;
    private int index;

    public Triangle() {
    }

    public Triangle(Vector3f p1, Vector3f p2, Vector3f p3) {
        this.pointA.set(p1);
        this.pointB.set(p2);
        this.pointC.set(p3);
    }

    public Vector3f get(int i) {
        switch (i) {
            case 0: {
                return this.pointA;
            }
            case 1: {
                return this.pointB;
            }
            case 2: {
                return this.pointC;
            }
        }
        return null;
    }

    @Override
    public Vector3f get1() {
        return this.pointA;
    }

    @Override
    public Vector3f get2() {
        return this.pointB;
    }

    @Override
    public Vector3f get3() {
        return this.pointC;
    }

    public void set(int i, Vector3f point) {
        this.center = null;
        this.normal = null;
        switch (i) {
            case 0: {
                this.pointA.set(point);
                break;
            }
            case 1: {
                this.pointB.set(point);
                break;
            }
            case 2: {
                this.pointC.set(point);
            }
        }
    }

    public void set(int i, float x, float y, float z) {
        this.center = null;
        this.normal = null;
        switch (i) {
            case 0: {
                this.pointA.set(x, y, z);
                break;
            }
            case 1: {
                this.pointB.set(x, y, z);
                break;
            }
            case 2: {
                this.pointC.set(x, y, z);
            }
        }
    }

    public void set1(Vector3f v) {
        this.center = null;
        this.normal = null;
        this.pointA.set(v);
    }

    public void set2(Vector3f v) {
        this.center = null;
        this.normal = null;
        this.pointB.set(v);
    }

    public void set3(Vector3f v) {
        this.center = null;
        this.normal = null;
        this.pointC.set(v);
    }

    @Override
    public void set(Vector3f v1, Vector3f v2, Vector3f v3) {
        this.center = null;
        this.normal = null;
        this.pointA.set(v1);
        this.pointB.set(v2);
        this.pointC.set(v3);
    }

    public void calculateCenter() {
        if (this.center == null) {
            this.center = new Vector3f(this.pointA);
        } else {
            this.center.set(this.pointA);
        }
        this.center.addLocal(this.pointB).addLocal(this.pointC).multLocal(0.33333334f);
    }

    public void calculateNormal() {
        if (this.normal == null) {
            this.normal = new Vector3f(this.pointB);
        } else {
            this.normal.set(this.pointB);
        }
        this.normal.subtractLocal(this.pointA).crossLocal(this.pointC.x - this.pointA.x, this.pointC.y - this.pointA.y, this.pointC.z - this.pointA.z);
        this.normal.normalizeLocal();
    }

    public Vector3f getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
    }

    public Vector3f getNormal() {
        if (this.normal == null) {
            this.calculateNormal();
        }
        return this.normal;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public float getProjection() {
        return this.projection;
    }

    public void setProjection(float projection) {
        this.projection = projection;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static Vector3f computeTriangleNormal(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f store) {
        if (store == null) {
            store = new Vector3f(v2);
        } else {
            store.set(v2);
        }
        store.subtractLocal(v1).crossLocal(v3.x - v1.x, v3.y - v1.y, v3.z - v1.z);
        return store.normalizeLocal();
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        e.getCapsule(this).write(this.pointA, "pointa", Vector3f.ZERO);
        e.getCapsule(this).write(this.pointB, "pointb", Vector3f.ZERO);
        e.getCapsule(this).write(this.pointC, "pointc", Vector3f.ZERO);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        this.pointA = (Vector3f)importer.getCapsule(this).readSavable("pointa", Vector3f.ZERO.clone());
        this.pointB = (Vector3f)importer.getCapsule(this).readSavable("pointb", Vector3f.ZERO.clone());
        this.pointC = (Vector3f)importer.getCapsule(this).readSavable("pointc", Vector3f.ZERO.clone());
    }

    public Triangle clone() {
        try {
            Triangle t = (Triangle)super.clone();
            t.pointA = this.pointA.clone();
            t.pointB = this.pointB.clone();
            t.pointC = this.pointC.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

