/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.EaseFunction;
import com.jme3.math.FastMath;

public class Easing {
    public static EaseFunction constant = new EaseFunction(){

        @Override
        public float apply(float value) {
            return 0.0f;
        }
    };
    public static EaseFunction linear = new EaseFunction(){

        @Override
        public float apply(float value) {
            return value;
        }
    };
    public static EaseFunction inQuad = new EaseFunction(){

        @Override
        public float apply(float value) {
            return value * value;
        }
    };
    public static EaseFunction inCubic = new EaseFunction(){

        @Override
        public float apply(float value) {
            return value * value * value;
        }
    };
    public static EaseFunction inQuart = new EaseFunction(){

        @Override
        public float apply(float value) {
            return value * value * value * value;
        }
    };
    public static EaseFunction inQuint = new EaseFunction(){

        @Override
        public float apply(float value) {
            return value * value * value * value * value;
        }
    };
    public static EaseFunction outElastic = new EaseFunction(){

        @Override
        public float apply(float value) {
            return FastMath.pow(2.0f, -10.0f * value) * FastMath.sin((value - 0.075f) * ((float)Math.PI * 2) / 0.3f) + 1.0f;
        }
    };
    public static EaseFunction outBounce = new EaseFunction(){

        @Override
        public float apply(float value) {
            if (value < 0.36363637f) {
                return 7.5625f * value * value;
            }
            if (value < 0.72727275f) {
                return 7.5625f * (value -= 0.54545456f) * value + 0.75f;
            }
            if ((double)value < 0.9090909090909091) {
                return 7.5625f * (value -= 0.8181818f) * value + 0.9375f;
            }
            return 7.5625f * (value -= 0.95454544f) * value + 0.984375f;
        }
    };
    public static EaseFunction inElastic = new Invert(outElastic);
    public static EaseFunction inBounce = new Invert(outBounce);
    public static EaseFunction outQuad = new Invert(inQuad);
    public static EaseFunction outCubic = new Invert(inCubic);
    public static EaseFunction outQuart = new Invert(inQuart);
    public static EaseFunction outQuint = new Invert(inQuint);
    public static EaseFunction inOutQuad = new InOut(inQuad, outQuad);
    public static EaseFunction inOutCubic = new InOut(inCubic, outCubic);
    public static EaseFunction inOutQuart = new InOut(inQuart, outQuart);
    public static EaseFunction inOutQuint = new InOut(inQuint, outQuint);
    public static EaseFunction inOutElastic = new InOut(inElastic, outElastic);
    public static EaseFunction inOutBounce = new InOut(inBounce, outBounce);
    public static EaseFunction smoothStep = new EaseFunction(){

        @Override
        public float apply(float t) {
            return t * t * (3.0f - 2.0f * t);
        }
    };
    public static EaseFunction smootherStep = new EaseFunction(){

        @Override
        public float apply(float t) {
            return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
        }
    };

    private Easing() {
    }

    private static class Invert
    implements EaseFunction {
        private final EaseFunction func;

        public Invert(EaseFunction func) {
            this.func = func;
        }

        @Override
        public float apply(float value) {
            return 1.0f - this.func.apply(1.0f - value);
        }
    }

    public static class InOut
    implements EaseFunction {
        private final EaseFunction in;
        private final EaseFunction out;

        public InOut(EaseFunction in, EaseFunction out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public float apply(float value) {
            if ((double)value < 0.5) {
                return this.in.apply(value *= 2.0f) / 2.0f;
            }
            value = (value - 0.5f) * 2.0f;
            return this.out.apply(value) / 2.0f + 0.5f;
        }
    }
}

