/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.Intersection;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.ProbeArea;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.util.TempVars;
import java.io.IOException;

public class SphereProbeArea
implements ProbeArea {
    private Vector3f center = new Vector3f();
    private float radius = 1.0f;
    private final Matrix4f uniformMatrix = new Matrix4f();

    public SphereProbeArea() {
    }

    public SphereProbeArea(Vector3f center, float radius) {
        this.center.set(center);
        this.radius = radius;
        this.updateMatrix();
    }

    public Vector3f getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(Vector3f center) {
        this.center.set(center);
        this.updateMatrix();
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(float radius) {
        this.radius = radius;
        this.updateMatrix();
    }

    @Override
    public Matrix4f getUniformMatrix() {
        return this.uniformMatrix;
    }

    private void updateMatrix() {
        this.uniformMatrix.m03 = this.center.x;
        this.uniformMatrix.m13 = this.center.y;
        this.uniformMatrix.m23 = this.center.z;
    }

    @Override
    public boolean intersectsBox(BoundingBox box, TempVars vars) {
        return Intersection.intersect(box, this.center, this.radius);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere sphere, TempVars vars) {
        return Intersection.intersect(sphere, this.center, this.radius);
    }

    @Override
    public boolean intersectsFrustum(Camera camera, TempVars vars) {
        return Intersection.intersect(camera, this.center, this.radius);
    }

    public String toString() {
        return "SphereProbeArea{center=" + this.center + ", radius=" + this.radius + '}';
    }

    protected SphereProbeArea clone() throws CloneNotSupportedException {
        return new SphereProbeArea(this.center, this.radius);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        OutputCapsule oc = e.getCapsule(this);
        oc.write(this.center, "center", new Vector3f());
        oc.write(this.radius, "radius", 1.0f);
    }

    @Override
    public void read(JmeImporter i) throws IOException {
        InputCapsule ic = i.getCapsule(this);
        this.center = (Vector3f)ic.readSavable("center", new Vector3f());
        this.radius = ic.readFloat("radius", 1.0f);
        this.updateMatrix();
    }
}

