/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.JoystickAxis;
import com.jme3.input.JoystickButton;
import com.jme3.input.controls.JoyAxisTrigger;
import com.jme3.input.controls.JoyButtonTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractJoystick
implements Joystick {
    private final InputManager inputManager;
    private final JoyInput joyInput;
    private final int joyId;
    private final String name;
    private final List<JoystickAxis> axes = new ArrayList<JoystickAxis>();
    private final List<JoystickButton> buttons = new ArrayList<JoystickButton>();

    protected AbstractJoystick(InputManager inputManager, JoyInput joyInput, int joyId, String name) {
        this.inputManager = inputManager;
        this.joyInput = joyInput;
        this.joyId = joyId;
        this.name = name;
    }

    protected InputManager getInputManager() {
        return this.inputManager;
    }

    protected JoyInput getJoyInput() {
        return this.joyInput;
    }

    protected void addAxis(JoystickAxis axis) {
        this.axes.add(axis);
    }

    protected void addButton(JoystickButton button) {
        this.buttons.add(button);
    }

    @Override
    public void rumble(float amount) {
        this.joyInput.setJoyRumble(this.joyId, amount);
    }

    @Override
    @Deprecated
    public void assignButton(String mappingName, int buttonId) {
        if (buttonId < 0 || buttonId >= this.getButtonCount()) {
            throw new IllegalArgumentException();
        }
        this.inputManager.addMapping(mappingName, new JoyButtonTrigger(this.joyId, buttonId));
    }

    @Override
    @Deprecated
    public void assignAxis(String positiveMapping, String negativeMapping, int axisId) {
        if (axisId == 254) {
            axisId = this.getPovXAxis().getAxisId();
        } else if (axisId == 255) {
            axisId = this.getPovYAxis().getAxisId();
        }
        this.inputManager.addMapping(positiveMapping, new JoyAxisTrigger(this.joyId, axisId, false));
        this.inputManager.addMapping(negativeMapping, new JoyAxisTrigger(this.joyId, axisId, true));
    }

    @Override
    public JoystickAxis getAxis(String logicalId) {
        for (JoystickAxis axis : this.axes) {
            if (!axis.getLogicalId().equals(logicalId)) continue;
            return axis;
        }
        return null;
    }

    @Override
    public List<JoystickAxis> getAxes() {
        return Collections.unmodifiableList(this.axes);
    }

    @Override
    public int getAxisCount() {
        return this.axes.size();
    }

    @Override
    public JoystickButton getButton(String logicalId) {
        for (JoystickButton b : this.buttons) {
            if (!b.getLogicalId().equals(logicalId)) continue;
            return b;
        }
        return null;
    }

    @Override
    public List<JoystickButton> getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    @Override
    public int getButtonCount() {
        return this.buttons.size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getJoyId() {
        return this.joyId;
    }

    @Override
    public int getXAxisIndex() {
        return this.getXAxis().getAxisId();
    }

    @Override
    public int getYAxisIndex() {
        return this.getYAxis().getAxisId();
    }

    public String toString() {
        return "Joystick[name=" + this.name + ", id=" + this.joyId + ", buttons=" + this.getButtonCount() + ", axes=" + this.getAxisCount() + "]";
    }
}

