/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.environment;

import com.jme3.asset.AssetManager;
import com.jme3.environment.baker.IBLGLEnvBakerLight;
import com.jme3.environment.util.EnvMapUtils;
import com.jme3.light.LightProbe;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;

public class FastLightProbeFactory {
    public static LightProbe makeProbe(RenderManager rm, AssetManager am, int size, Vector3f pos, float frustumNear, float frustumFar, Spatial scene) {
        IBLGLEnvBakerLight baker = new IBLGLEnvBakerLight(rm, am, Image.Format.RGB16F, Image.Format.Depth, size, size);
        baker.setTexturePulling(true);
        baker.bakeEnvironment(scene, pos, frustumNear, frustumFar, null);
        baker.bakeSpecularIBL();
        baker.bakeSphericalHarmonicsCoefficients();
        LightProbe probe = new LightProbe();
        probe.setPosition(pos);
        probe.setPrefilteredMap(baker.getSpecularIBL());
        int[] mipSizes = probe.getPrefilteredEnvMap().getImage().getMipMapSizes();
        probe.setNbMipMaps(mipSizes != null ? mipSizes.length : 1);
        probe.setShCoeffs(baker.getSphericalHarmonicsCoefficients());
        probe.setReady(true);
        baker.clean();
        return probe;
    }

    public static Node getDebugGui(AssetManager manager, LightProbe probe) {
        if (!probe.isReady()) {
            throw new UnsupportedOperationException("This EnvProbe is not ready yet, try to test isReady()");
        }
        Node debugNode = new Node("debug gui probe");
        Node debugPfemCm = EnvMapUtils.getCubeMapCrossDebugViewWithMipMaps(probe.getPrefilteredEnvMap(), manager);
        debugNode.attachChild(debugPfemCm);
        debugPfemCm.setLocalTranslation(520.0f, 0.0f, 0.0f);
        return debugNode;
    }
}

