/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.tween.action;

import com.jme3.anim.AnimationMask;
import com.jme3.anim.tween.Tween;
import com.jme3.anim.tween.action.BaseAction;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;

public abstract class Action
implements JmeCloneable,
Tween {
    protected Action[] actions;
    private double length;
    private double speed = 1.0;
    private AnimationMask mask;
    private boolean forward = true;

    protected Action(Tween ... tweens) {
        this.actions = new Action[tweens.length];
        for (int i = 0; i < tweens.length; ++i) {
            Tween tween = tweens[i];
            this.actions[i] = tween instanceof Action ? (Action)tween : new BaseAction(tween);
        }
    }

    @Override
    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
        if (speed < 0.0) {
            this.setForward(false);
        } else {
            this.setForward(true);
        }
    }

    public AnimationMask getMask() {
        return this.mask;
    }

    public void setMask(AnimationMask mask) {
        this.mask = mask;
    }

    @Override
    public Action jmeClone() {
        try {
            Action clone = (Action)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.actions = cloner.clone(this.actions);
        this.mask = cloner.clone(this.mask);
    }

    protected boolean isForward() {
        return this.forward;
    }

    protected void setForward(boolean forward) {
        if (this.forward == forward) {
            return;
        }
        this.forward = forward;
        for (Action action : this.actions) {
            action.setForward(forward);
        }
    }
}

