/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.AnimLayer;
import com.jme3.anim.ArmatureMask;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.scene.Spatial;

public class SingleLayerInfluenceMask
extends ArmatureMask {
    private final String layer;
    private final AnimComposer anim;
    private final SkinningControl skin;
    private boolean checkUpperLayers = true;

    public SingleLayerInfluenceMask(String layer, Spatial spatial) {
        this.layer = layer;
        this.anim = spatial.getControl(AnimComposer.class);
        this.skin = spatial.getControl(SkinningControl.class);
    }

    public SingleLayerInfluenceMask(String layer, AnimComposer anim, SkinningControl skin) {
        this.layer = layer;
        this.anim = anim;
        this.skin = skin;
    }

    public void makeLayer() {
        this.anim.makeLayer(this.layer, this);
    }

    public SingleLayerInfluenceMask addAll() {
        for (Joint j : this.skin.getArmature().getJointList()) {
            super.addBones(this.skin.getArmature(), j.getName());
        }
        return this;
    }

    public SingleLayerInfluenceMask addFromJoint(String joint) {
        super.addFromJoint(this.skin.getArmature(), joint);
        return this;
    }

    public SingleLayerInfluenceMask addJoints(String ... joints) {
        super.addBones(this.skin.getArmature(), joints);
        return this;
    }

    public SingleLayerInfluenceMask setCheckUpperLayers(boolean check) {
        this.checkUpperLayers = check;
        return this;
    }

    public String getTargetLayer() {
        return this.layer;
    }

    public AnimComposer getAnimComposer() {
        return this.anim;
    }

    public SkinningControl getSkinningControl() {
        return this.skin;
    }

    public boolean isCheckUpperLayers() {
        return this.checkUpperLayers;
    }

    @Override
    public boolean contains(Object target) {
        return this.simpleContains(target) && (!this.checkUpperLayers || !this.isAffectedByUpperLayers(target));
    }

    private boolean simpleContains(Object target) {
        return super.contains(target);
    }

    private boolean isAffectedByUpperLayers(Object target) {
        boolean higher = false;
        for (String name : this.anim.getLayerNames()) {
            AnimLayer lyr;
            if (name.equals(this.layer)) {
                higher = true;
                continue;
            }
            if (!higher || (lyr = this.anim.getLayer(name)).getCurrentAction() == null || !(lyr.getMask() instanceof SingleLayerInfluenceMask ? ((SingleLayerInfluenceMask)lyr.getMask()).simpleContains(target) : lyr.getMask().contains(target))) continue;
            return true;
        }
        return false;
    }

    public static SingleLayerInfluenceMask all(String layer, Spatial spatial) {
        return new SingleLayerInfluenceMask(layer, spatial).addAll();
    }

    public static SingleLayerInfluenceMask all(String layer, AnimComposer anim, SkinningControl skin) {
        return new SingleLayerInfluenceMask(layer, anim, skin).addAll();
    }
}

