/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimationMask;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import java.util.BitSet;

public class ArmatureMask
implements AnimationMask {
    private final BitSet affectedJoints = new BitSet();

    public ArmatureMask() {
    }

    public ArmatureMask(Armature armature) {
        int numJoints = armature.getJointCount();
        this.affectedJoints.set(0, numJoints);
    }

    public ArmatureMask remove(ArmatureMask removeMask) {
        BitSet removeBits = removeMask.getAffectedJoints();
        this.affectedJoints.andNot(removeBits);
        return this;
    }

    private BitSet getAffectedJoints() {
        return this.affectedJoints;
    }

    public ArmatureMask removeJoints(Armature armature, String ... jointNames) {
        for (String jointName : jointNames) {
            Joint joint = this.findJoint(armature, jointName);
            int jointId = joint.getId();
            this.affectedJoints.clear(jointId);
        }
        return this;
    }

    @Override
    public boolean contains(Object target) {
        return this.affectedJoints.get(((Joint)target).getId());
    }

    public static ArmatureMask createMask(Armature armature, String fromJoint) {
        ArmatureMask mask = new ArmatureMask();
        mask.addFromJoint(armature, fromJoint);
        return mask;
    }

    public static ArmatureMask createMask(Armature armature, String ... joints) {
        ArmatureMask mask = new ArmatureMask();
        mask.addBones(armature, joints);
        return mask;
    }

    public void addBones(Armature armature, String ... jointNames) {
        for (String jointName : jointNames) {
            Joint joint = this.findJoint(armature, jointName);
            this.affectedJoints.set(joint.getId());
        }
    }

    private Joint findJoint(Armature armature, String jointName) {
        Joint joint = armature.getJoint(jointName);
        if (joint == null) {
            throw new IllegalArgumentException("Cannot find joint " + jointName);
        }
        return joint;
    }

    public void addFromJoint(Armature armature, String jointName) {
        Joint joint = this.findJoint(armature, jointName);
        this.recurseAddJoint(joint);
    }

    private void recurseAddJoint(Joint joint) {
        this.affectedJoints.set(joint.getId());
        for (Joint j : joint.getChildren()) {
            this.recurseAddJoint(j);
        }
    }

    public ArmatureMask addAncestors(Joint start) {
        for (Joint cur = start; cur != null; cur = cur.getParent()) {
            int jointId = cur.getId();
            this.affectedJoints.set(jointId);
        }
        return this;
    }

    public ArmatureMask removeAncestors(Joint start) {
        for (Joint cur = start; cur != null; cur = cur.getParent()) {
            int jointId = cur.getId();
            this.affectedJoints.clear(jointId);
        }
        return this;
    }
}

