/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim;

import com.jme3.anim.AnimTrack;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class AnimClip
implements JmeCloneable,
Savable {
    private String name;
    private double length;
    private AnimTrack[] tracks;

    protected AnimClip() {
    }

    public AnimClip(String name) {
        this.name = name;
    }

    public void setTracks(AnimTrack[] tracks) {
        this.tracks = tracks;
        for (AnimTrack track : tracks) {
            if (!(track.getLength() > this.length)) continue;
            this.length = track.getLength();
        }
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public AnimTrack[] getTracks() {
        return this.tracks;
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        AnimTrack[] newTracks = new AnimTrack[this.tracks.length];
        for (int i = 0; i < this.tracks.length; ++i) {
            newTracks[i] = cloner.clone(this.tracks[i]);
        }
        this.tracks = newTracks;
    }

    public String toString() {
        return "Clip " + this.name + ", " + this.length + 's';
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        oc.write(this.tracks, "tracks", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        Savable[] arr = ic.readSavableArray("tracks", null);
        if (arr != null) {
            this.tracks = new AnimTrack[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                AnimTrack t;
                this.tracks[i] = t = (AnimTrack)arr[i];
                if (!(t.getLength() > this.length)) continue;
                this.length = t.getLength();
            }
        }
    }
}

