/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;

public abstract class PhysicsJoint
implements Savable {
    protected TypedConstraint constraint;
    protected PhysicsRigidBody nodeA;
    protected PhysicsRigidBody nodeB;
    protected Vector3f pivotA;
    protected Vector3f pivotB;
    protected boolean collisionBetweenLinkedBodys = true;

    protected PhysicsJoint() {
    }

    public PhysicsJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB) {
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.pivotA = pivotA;
        this.pivotB = pivotB;
        nodeA.addJoint(this);
        nodeB.addJoint(this);
    }

    public float getAppliedImpulse() {
        return this.constraint.getAppliedImpulse();
    }

    public TypedConstraint getObjectId() {
        return this.constraint;
    }

    public boolean isCollisionBetweenLinkedBodys() {
        return this.collisionBetweenLinkedBodys;
    }

    public void setCollisionBetweenLinkedBodys(boolean collisionBetweenLinkedBodies) {
        this.collisionBetweenLinkedBodys = collisionBetweenLinkedBodies;
    }

    public PhysicsRigidBody getBodyA() {
        return this.nodeA;
    }

    public PhysicsRigidBody getBodyB() {
        return this.nodeB;
    }

    public Vector3f getPivotA() {
        return this.pivotA;
    }

    public Vector3f getPivotB() {
        return this.pivotB;
    }

    public void destroy() {
        this.getBodyA().removeJoint(this);
        this.getBodyB().removeJoint(this);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.nodeA, "nodeA", null);
        capsule.write((Savable)this.nodeB, "nodeB", null);
        capsule.write((Savable)this.pivotA, "pivotA", null);
        capsule.write((Savable)this.pivotB, "pivotB", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.nodeA = (PhysicsRigidBody)capsule.readSavable("nodeA", null);
        this.nodeB = (PhysicsRigidBody)capsule.readSavable("nodeB", null);
        this.pivotA = (Vector3f)capsule.readSavable("pivotA", (Savable)new Vector3f());
        this.pivotB = (Vector3f)capsule.readSavable("pivotB", (Savable)new Vector3f());
    }
}

